using System;
using DarkStrideToolbox;


namespace MetalMarines
{
	public enum enumExplosionType
	{
		Building,
		MetalMarine,
		AAShot
	};

	public class Explosion
	{
		#region Properties
		private string m_sGlobalID = "";
		private string m_sDelayTillThisExploIsDone = "";
		private double m_nTimeIntoExplosion = 0;
		private string m_sIslandGlobalID = "";
		private long m_nSquareX = 0;
		private long m_nSquareY = 0;
		private double m_nMenuPercX = 0;
		private double m_nMenuPercY = 0;
		private enumExplosionType m_nExplosionType = 0;
		private long m_nPosX = 0;
		private long m_nPosY = 0;
		private bool m_bIsAntiMatter = false;
		private bool m_bPlaySound = false;

		private static string m_cBLDEXPLO_SEP = "[EX]";
		#endregion


		public Explosion()
		{
			m_sGlobalID = DSMisc.GetGUID();
		}



		public void Advance( double nElapsedTime,DSSortedList oExplosions,DSGameEngine oGameEngine )
		{
			Explosion oExplosion = null;

			if( m_sDelayTillThisExploIsDone.Length > 0 )
			{
				oExplosion = (Explosion)oExplosions.GetByKey( m_sDelayTillThisExploIsDone );

				//This means our previuos explosion finished so we can go on
				if( oExplosion == null )
				{
					m_sDelayTillThisExploIsDone = "";
				}
			}

			if( m_sDelayTillThisExploIsDone.Length == 0 )
			{
				if( m_nTimeIntoExplosion == 0 && m_bIsAntiMatter == false && m_bPlaySound == true )
				{
					if( m_nExplosionType == enumExplosionType.Building )
					{
						oGameEngine.DirectSound.PlaySound( Game.m_cGOB_SOUND_EXPLOSION );					
					}
					else
					{
						oGameEngine.DirectSound.PlaySound( Game.m_cGOB_SOUND_AAEXPLOSION );					
					}
				}
				m_nTimeIntoExplosion += nElapsedTime;
			}
		}


		public string Serialize()
		{
			string sRetVal = "";


			//Now write all the square information
			sRetVal =	m_sGlobalID + m_cBLDEXPLO_SEP + 
						m_sDelayTillThisExploIsDone + m_cBLDEXPLO_SEP +
						m_nTimeIntoExplosion.ToString() + m_cBLDEXPLO_SEP +
					    m_sIslandGlobalID + m_cBLDEXPLO_SEP + 
						m_nSquareX.ToString() + m_cBLDEXPLO_SEP + 
						m_nSquareY.ToString() + m_cBLDEXPLO_SEP + 
						Convert.ToInt64( m_nExplosionType ).ToString() + m_cBLDEXPLO_SEP + 
						m_bIsAntiMatter.ToString() + m_cBLDEXPLO_SEP + 
						m_bPlaySound.ToString() + m_cBLDEXPLO_SEP;


			return( sRetVal );
		}
		public void DeSerialize( string sRecord )
		{
			string[] saExplosionParams = null;

			saExplosionParams = DSMisc.Split( sRecord,m_cBLDEXPLO_SEP );

			//Now update this explosion
			m_sGlobalID					= saExplosionParams[ 0 ];
			m_sDelayTillThisExploIsDone	= saExplosionParams[ 1 ];
			m_nTimeIntoExplosion		= Convert.ToDouble( saExplosionParams[ 2 ] );
			m_sIslandGlobalID			= saExplosionParams[ 3 ];
			m_nSquareX					= Convert.ToInt64( saExplosionParams[ 4 ] );
			m_nSquareY					= Convert.ToInt64( saExplosionParams[ 5 ] );
			m_nExplosionType			= (enumExplosionType)Convert.ToInt64( saExplosionParams[ 6 ] );
			m_bIsAntiMatter				= Convert.ToBoolean( saExplosionParams[ 7 ] );
			m_bPlaySound				= Convert.ToBoolean( saExplosionParams[ 8 ] );
		}



		#region Properties
		public string GlobalID
		{
			get
			{
				return( m_sGlobalID );
			}
			set
			{
				m_sGlobalID = value;
			}
		}
		public string DelayTillThisExploIsDone
		{
			get
			{
				return( m_sDelayTillThisExploIsDone );
			}
			set
			{
				m_sDelayTillThisExploIsDone = value;
			}
		}
		public double TimeIntoExplosion
		{
			get
			{
				return( m_nTimeIntoExplosion );
			}
			set
			{
				m_nTimeIntoExplosion = value;
			}
		}
		public string IslandGlobalID
		{
			get
			{
				return( m_sIslandGlobalID );
			}
			set
			{
				m_sIslandGlobalID = value;
			}
		}
		public long SquareX
		{
			get
			{
				return( m_nSquareX );
			}
			set
			{
				m_nSquareX = value;
			}
		}
		public long SquareY
		{
			get
			{
				return( m_nSquareY );
			}
			set
			{
				m_nSquareY = value;
			}
		}
		public enumExplosionType ExplosionType
		{
			get
			{
				return( m_nExplosionType );
			}
			set
			{
				m_nExplosionType = value;
			}
		}
		public long PosX
		{
			get
			{
				return( m_nPosX );
			}
			set
			{
				m_nPosX = value;
			}
		}
		public long PosY
		{
			get
			{
				return( m_nPosY );
			}
			set
			{
				m_nPosY = value;
			}
		}
		public bool IsAntiMatter
		{
			get
			{
				return( m_bIsAntiMatter );
			}
			set
			{
				m_bIsAntiMatter = value;
			}
		}
		public bool PlaySound
		{
			get
			{
				return( m_bPlaySound );
			}
			set
			{
				m_bPlaySound = value;
			}
		}
		public double MenuPercX
		{
			get
			{
				return( m_nMenuPercX );
			}
			set
			{
				m_nMenuPercX = value;
			}
		}
		public double MenuPercY
		{
			get
			{
				return( m_nMenuPercY );
			}
			set
			{
				m_nMenuPercY = value;
			}
		}
		#endregion
	}
}
